﻿function Confirm-TSProgressUISetup(){
    if ($Script:TaskSequenceProgressUi -eq $null){
        try{$Script:TaskSequenceProgressUi = New-Object -ComObject Microsoft.SMS.TSProgressUI}
        catch{throw "Unable to connect to the Task Sequence Progress UI! Please verify you are in a running Task Sequence Environment. Please note: TSProgressUI cannot be loaded during a prestart command.`n`nErrorDetails:`n$_"}
        }
    }

function Confirm-TSEnvironmentSetup(){
    if ($Script:TaskSequenceEnvironment -eq $null){
        try{$Script:TaskSequenceEnvironment = New-Object -ComObject Microsoft.SMS.TSEnvironment}
        catch{throw "Unable to connect to the Task Sequence Environment! Please verify you are in a running Task Sequence Environment.`n`nErrorDetails:`n$_"}
        }
    }

function Show-TSActionProgress()
{

    param(
        [Parameter(Mandatory=$true)]
        [string] $Message,
        [Parameter(Mandatory=$true)]
        [long] $Step,
        [Parameter(Mandatory=$true)]
        [long] $MaxStep
    )

    Confirm-TSProgressUISetup
    Confirm-TSEnvironmentSetup

    $Script:TaskSequenceProgressUi.ShowActionProgress(`
        $Script:TaskSequenceEnvironment.Value("_SMSTSOrgName"),`
        $Script:TaskSequenceEnvironment.Value("_SMSTSPackageName"),`
        $Script:TaskSequenceEnvironment.Value("_SMSTSCustomProgressDialogMessage"),`
        $Script:TaskSequenceEnvironment.Value("_SMSTSCurrentActionName"),`
        [Convert]::ToUInt32($Script:TaskSequenceEnvironment.Value("_SMSTSNextInstructionPointer")),`
        [Convert]::ToUInt32($Script:TaskSequenceEnvironment.Value("_SMSTSInstructionTableSize")),`
        $Message,`
        $Step,`
        $MaxStep)
}

Function Get-WinMagicStatus {
$global:WinMagicRegistryPath = "HKLM:\SOFTWARE\WinMagic\SecureDoc"
if (Test-Path $WinMagicRegistryPath)
    {
    $global:FixedDiskEncrypted = Get-ItemPropertyValue -Path "HKLM:\SOFTWARE\WinMagic" -Name "FixedDiskEncrypted"
    $global:FixedDiskEncryptedTable =@(
    @{ Value = "0"; Friendly = "Not Encrypted"}
    @{ Value = "1"; Friendly = "Encrypted"}
    @{ Value = "2"; Friendly = "there are multiple drives, and some are encrypted and some are decrypted"}
    @{ Value = "5"; Friendly = "Encryption is in progress"}
    @{ Value = "9"; Friendly = "Decryption is in progress"}
    ) 
    $global:FixedDiskEncryptedStatus = ($FixedDiskEncryptedTable | Where-Object {$_.Value -eq $FixedDiskEncrypted}).Friendly

    $global:WinMagicRegistryItem = Get-Item -Path $WinMagicRegistryPath    
    $global:AutoBootStatus = $WinMagicRegistryItem.GetValue('AutoBootStatus')
    $global:AutoBootCounter = $WinMagicRegistryItem.GetValue('AutoBootCounter')
    $global:AutoBootTimeOut = $WinMagicRegistryItem.GetValue('AutoBootTimeOut')
    $global:AutoBootTable =@(
    @{ Value = "0"; Friendly = "Not Bypassed"}
    @{ Value = "1"; Friendly = "Permanent Bypass"}
    @{ Value = "2"; Friendly = "Temporary Bypass"}
    ) 
    $global:BypassStatus = ($AutoBootTable | Where-Object {$_.Value -eq $AutoBootStatus}).Friendly
    if ($WinMagicRegistryItem.GetValue('ConversionProgress') -ne $null -or  $WinMagicRegistryItem.GetValue('ConversionProgress') -ne "")
        {
        $global:ConversionProgress = $WinMagicRegistryItem.GetValue('ConversionProgress')
        $global:ConversionDirection = $WinMagicRegistryItem.GetValue('ConversionDirection')
        $global:ConversionDirectionTable =@(
            @{ Value = "0"; Friendly = "Decrypting"}
            @{ Value = "1"; Friendly = "Encrypting"}
        )
        $global:ConversionDirectionFriendly = ($ConversionDirectionTable | Where-Object {$_.Value -eq $ConversionDirection}).Friendly
        }
    }
}

Get-WinMagicStatus
Write-Output "------------------------------------------"
Write-Output " "
#write overall status:
Write-Output "Encrypted Status: $FixedDiskEncryptedStatus"
Write-Output "Last Action: $ConversionDirectionFriendly"
Write-Output "Last Action % Complete: $ConversionProgress"
Write-Output " "
Write-Output "------------------------------------------"
Write-Output " "
#Start Looping for waiting:
if ($FixedDiskEncrypted -ne "1")
    {

    if ($ConversionProgress -ne $null -and $ConversionProgress -ne "" -or $ConversionProgress -eq 0)
        {
        Write-Output "$FixedDiskEncryptedStatus at $($ConversionProgress)%"
        Show-TSActionProgress -Message "$FixedDiskEncryptedStatus $($ConversionProgress)%" -Step $ConversionProgress -MaxStep 100 -ErrorAction SilentlyContinue
        do
            {
            start-sleep -Seconds 60
            Get-WinMagicStatus
            Write-Output "$FixedDiskEncryptedStatus at $($ConversionProgress)%"
            Show-TSActionProgress -Message "$FixedDiskEncryptedStatus $($ConversionProgress)%" -Step $ConversionProgress -MaxStep 100 -ErrorAction SilentlyContinue
            }
        until
            (
            $FixedDiskEncrypted -eq 1 -or $FixedDiskEncrypted -eq 0
            )
        }
    }
else
    {
    Write-Output "System is fully encrypted"
    }
Write-Output " "
Write-Output "------------------------------------------"
[Void]([wmiclass]'ROOT\ccm:SMS_Client').TriggerSchedule('{00000000-0000-0000-0000-000000000001}')